<?php

/**

 * @package 

 * @version 1.0.3 

 * @author Jason Lau

 * @link http://jasonlau.biz

 * @copyright 2011

 * @license GNU/GPL 3+

 * @uses WordPress

 

Plugin Name: Visitor Maps Extended Referer Field

Plugin URI: http://jasonlau.biz

Description: This WordPress plugin extends and depends on the <a href="http://www.642weather.com/weather/scripts-wordpress-visitor-maps.php" target="_blank">Visitor Maps and Who's Online</a> plugin by <a title="Visit author homepage" href="http://www.642weather.com/weather/scripts.php" target="_blank">Mike Challis</a>. This plugin alters the <em>Referer</em> column for the Admin's <em>Who's Been Online</em> grid, so it displays the referring host name followed by the search string, if there is one. It also prevents long URLs from expanding the grid too wide for viewing. There are no settings required.

Author: Jason Lau

Version: 1.0.3

Author URI: http://jasonlau.biz

*/



if (realpath(__FILE__) == realpath($_SERVER['SCRIPT_FILENAME'])) {

    exit('Please don\'t access this file directly.');

}





function visitor_maps_extended_ref(){

    wp_enqueue_script('jquery');

    wp_register_script('visitor_maps_extended_referer', plugins_url('/visitor-maps-extended-referer-field/visitor-maps-extended-referer.js', dirname(__FILE__)));

    wp_enqueue_script('visitor_maps_extended_referer');

}

if(is_dir(plugin_dir_path('visitor-maps'))) add_action('admin_enqueue_scripts', 'visitor_maps_extended_ref');

?>