/**

 * @package 

 * @version 1.0.3 

 * @author Jason Lau

 * @link http://jasonlau.biz

 * @copyright 2011

 * @license GNU/GPL 3+

 * @uses WordPress



Plugin Name: Visitor Maps Extended Referer

Plugin URI: http://jasonlau.biz

Description: This WordPress plugin extends and depends on the <a href="http://www.642weather.com/weather/scripts-wordpress-visitor-maps.php" target="_blank">Visitor Maps and Who's Online</a> plugin by <a title="Visit author homepage" href="http://www.642weather.com/weather/scripts.php" target="_blank">Mike Challis</a>. This plugin alters the <em>Referer</em> column for the Admin's <em>Who's Been Online</em> grid, so it displays the referring host name followed by the search string, if there is one. It also prevents long URLs from expanding the grid too wide for viewing. There are no settings required.

Author: Jason Lau

Version: 1.0.3

Author URI: http://jasonlau.biz

*/



jQuery(function($){

    var LINK_MAX_WIDTH = 400,

    getHostname = function(str) {

        var re = new RegExp('^(?:f|ht)tp(?:s)?\://([^/]+)', 'im');

        return str.match(re)[1].toString();

    },

    getUrlVars = function(original_link){

        var vars = {};

        var parts = original_link.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value){

            vars[key] = value;

        });

        return vars;

    };



    if(getUrlVars(window.location.href)["page"] == 'whos-been-online'){            

    $("font[color='green'] a").each(function(){       

        var original_link = $(this).attr("href");

        var q = getUrlVars(original_link)["q"];

        if(!q && getUrlVars(original_link)["p"]){

            q = getUrlVars(original_link)["p"];

        }



        if(original_link){

            if(q){

                q = q.replace(/%20|%2B|\+/gi, " ");

                q = q.replace(/%3E|%3C/gi,"");

                $(this).html(getHostname(original_link).replace(/www./gi, " "));

                $(this).after(' ' + unescape(q));

            } else {

                $(this).html(getHostname(original_link).replace(/www./gi, " "));

            }           

        }                

    });  



    $(".table-top td:contains('Referer')").append(" & Search String");    

    $(".column-dark td:contains(a), .column-light td:contains(a)").each(function(){

        $(this).wrapInner('<div style="max-width:' + LINK_MAX_WIDTH + 'px; overflow:hidden; padding:0px; margin:0px"></div>');

    });    

    }    

});