<?php
/**
 * This file will update the Twilio answering url and method
 * @author      Rizwan Haider
 *
 */
require_once "index.php";

/**
 * Set the answering url
 *
 */

// first get the account information
$account_numbers = $twilio->getAllPhoneNumbers();

//print_array($account_numbers,true);
// then set the url for it
foreach ( $account_numbers as $number ) {

	if ( $number == $twilio_number ) {

		// getting number details to get the num_sid
		$num_detail = $twilio->getTwilioNumberDetails( $number );

		// setting update array for number configurations
		$config = array(
			'num_sid'      => $num_detail['sid'],
			'FriendlyName' => 'automated Call Forward',
			'VoiceUrl'     => $voice_url,
			'VoiceMethod'  => 'POST',
		);

		// updating number details
		$result = $twilio->updateNumberURLS( $config );
	}
}
