<?php
/**
 * Created by PhpStorm.
 * User: Rizwan Haider
 * Date: 17/02/2017
 */

namespace rizwan_haider;

use Services_Twilio;
use Services_Twilio_RestException;

/**
 * Class Twilio
 * @package rizwan_haider
 */
class Twilio {


	private $account_sid;
	private $auth_token;

	/**
	 * Twilio constructor.
	 *
	 * @param $account_sid
	 * @param $auth_token
	 */
	public function __construct( $account_sid, $auth_token ) {

		// initialising Twilio API data members
		$this->setAccountSid( $account_sid );
		$this->setAuthToken( $auth_token );

	}


	/**
	 * Set account ssid
	 *
	 * @param mixed $account_sid
	 *
	 * @return Twilio
	 */
	public function setAccountSid( $account_sid ) {
		$this->account_sid = $account_sid;

		return $this;
	}

	/**
	 * Set authentication token
	 *
	 * @param mixed $auth_token
	 *
	 * @return $this
	 */
	public function setAuthToken( $auth_token ) {
		$this->auth_token = $auth_token;

		return $this;
	}


	/**
	 * Update Twilio phone number URLs using Twilio REST API call
	 *
	 * @param array $config
	 *
	 * @return string
	 */
	public function updateNumberURLS( array $config ) {

		try {
			$client = new Services_Twilio( $this->account_sid, $this->auth_token );
			$number = $client->account->incoming_phone_numbers->get( $config['num_sid'] );
			$number->update( array(
				"FriendlyName"         => $config['FriendlyName'],
				"VoiceUrl"             => $config['VoiceUrl'],
				"VoiceMethod"          => $config['VoiceMethod'],
//				"StatusCallback"       => $config['StatusCallback'],
//				"StatusCallbackMethod" => $config['StatusCallbackMethod'],
//				"SmsUrl"               => $config['SmsUrl'],
//				"SmsMethod"            => $config['SmsMethod']

			) );

			return $number;
		} catch ( Services_Twilio_RestException $e ) {

			return $e->getMessage();
		}

	}


	/**
	 * Get all the incoming phone number of a Twilio accounts using Twilio REST API
	 * @return array
	 */
	public function getAllPhoneNumbers() {


		// settings important variables
		$client         = new Services_Twilio( $this->account_sid, $this->auth_token );
		$client_numbers = [];

		// Loop over the list of numbers and echo a property for each one
		foreach ( $client->account->incoming_phone_numbers as $number ) :
			$client_numbers[] = $number->phone_number;
		endforeach;

		return $client_numbers;
	}




	/**
	 * Get Twilio Phone number detail by phone number using Twilio REST API
	 *
	 * @param string $phone_number
	 *
	 * @return array
	 */
	public function getTwilioNumberDetails( $phone_number ) {


		$number_details = array();

		// Your Account Sid and Auth Token from twilio.com/user/account
		$client = new Services_Twilio( $this->account_sid, $this->auth_token );

		// Loop over the list of numbers and echo a property for each one
		foreach ( $client->account->incoming_phone_numbers as $number ) :

			if ( $number->phone_number == $phone_number ) :

				$number_details['number']        = $number->phone_number;
				$number_details['sid']           = $number->sid;
				$number_details['friendly_name'] = $number->friendly_name;
				$number_details['voice_url']     = $number->voice_url;
				$number_details['sms_url']       = $number->sms_url;

			endif;

		endforeach;

		return $number_details;

	}


}